/* 
 * Register file
 * (c) 2008 The University of Aizu
 */ 

module regfile
  //#(parameter word_length  = 32,
  //  parameter regadr_width = 5)
    (
     clk,
     
     write,
     adr_wport,
     data_wport,
     
     adr_rporta,
     adr_rportb,
     data_rporta,
     data_rportb
     );
   parameter word_length  = 32;
   parameter regadr_width = 5;
   
   input                     clk;
        
   input                     write;
   input [regadr_width-1:0]  adr_wport;
   input [word_length-1:0]   data_wport;
     
   input [regadr_width-1:0]  adr_rporta;
   input [regadr_width-1:0]  adr_rportb;
   output [word_length-1:0]  data_rporta;
   output [word_length-1:0]  data_rportb;
 
   reg [word_length-1:0] reg_cell[1:(1<<regadr_width)-1];

   wire selA;
   wire selB;
   wire [31:0] data_outa;
   wire [31:0] data_outb;   
   
   assign selA = write & (adr_rporta == adr_wport);
   assign selB = write & (adr_rportb == adr_wport);

   mux2 #(32) rf_outA (.in0(reg_cell[adr_rporta]), .in1(data_wport), .sel(selA), .out(data_outa));
   mux2 #(32) rf_outB (.in0(reg_cell[adr_rportb]), .in1(data_wport), .sel(selB), .out(data_outb));
     
   assign data_rporta = (adr_rporta == 'b0) ? 'b0 : data_outa;
   assign data_rportb = (adr_rportb == 'b0) ? 'b0 : data_outb;
   
   always @(posedge clk)
     if(write && adr_wport != 0)
       reg_cell[adr_wport] <= data_wport;
   
endmodule // regfile
