/* 
 * ALU
 * (c) 2008 The University of Aizu
 */ 

module mipsalu
  //#(parameter word_length=32)
    (
    in_a,
    in_b,
    sel,
    out
     );
   parameter word_length=32;
   
   input [word_length-1:0] 	 in_a;
   input [word_length-1:0] 	 in_b;
   input [2:0] 			 sel;
   output [word_length-1:0]  out;

   reg [word_length-1:0]  out;
   wire [word_length:0] Rsub;
      
   // a - b
   assign Rsub = {in_a[word_length-1],in_a} - {in_b[word_length-1],in_b};
      
   always @(sel or in_a or in_b) begin
      case (sel)
        `ALUSEL_AND: out <= in_a & in_b;
        `ALUSEL_OR:  out <= in_a | in_b;
        `ALUSEL_ADD: out <= in_a + in_b;
        `ALUSEL_SUB: out <= Rsub;
	`ALUSEL_SLT: out <= {31'b0,Rsub[word_length]};
        default:     out <= 'bx;
      endcase
   end

endmodule
