/* 
 * ALU controller
 * (c) 2008 The University of Aizu
 */ 

module alucontrol
  (
    field, op,
    aluop,
    aluc
   );
   
   input [5:0] 	     field, op;
   input [1:0] 	     aluop;
   output [2:0]  aluc;

   reg [2:0] 	 aluc;
   
      
   always @(field or op or aluop) begin
      case(aluop)
	`ALUOP_ADD  : aluc <= `ALUSEL_ADD; // W
	`ALUOP_SUB  : aluc <= `ALUSEL_SUB; // Branch
	`ALUOP_FUNC : begin                // R-type
	   case(field)
	     `MIPSFUNC_ADD : aluc <= `ALUSEL_ADD;
	     `MIPSFUNC_SUB : aluc <= `ALUSEL_SUB;
	     `MIPSFUNC_AND : aluc <= `ALUSEL_AND;
	     `MIPSFUNC_OR  : aluc <= `ALUSEL_OR;
	     `MIPSFUNC_SLT : aluc <= `ALUSEL_SLT;
	     default       : aluc <= `ALUSEL_DEFAULT;
	   endcase // case(field)
	end
	`ALUOP_IMM : begin
	   case(op)
	     `MIPSINST_ADDI : aluc <= `ALUSEL_ADD;
	     `MIPSINST_ANDI : aluc <= `ALUSEL_AND;
	     `MIPSINST_ORI  : aluc <= `ALUSEL_OR;
	     `MIPSINST_SLTI : aluc <= `ALUSEL_SLT;
	     default        : aluc <= `ALUSEL_DEFAULT;
	   endcase // case(op)
	end
      endcase // case(aluop)
   end // always @ (field or op or aluop)
   
endmodule // alucontrol
