/*
 * operation codes for mips processor
 */

`define MIPSINST_LW      6'b100011
`define MIPSINST_SW      6'b101011
`define MIPSINST_R_TYPE  6'b000000
`define MIPSINST_I_TYPE  6'b001xxx
`define MIPSINST_ADDI    6'b001000
`define MIPSINST_ANDI    6'b001100
`define MIPSINST_ORI     6'b001101
`define MIPSINST_SLTI    6'b001010
`define MIPSINST_BEQ     6'b000100
`define MIPSINST_J       6'b000010
`define MIPSINST_JAL     6'b000011

`define ALUOP_ADD   2'b00
`define ALUOP_SUB   2'b01
`define ALUOP_FUNC  2'b10
`define ALUOP_IMM   2'b11

`define ALUSEL_AND      3'b000
`define ALUSEL_OR       3'b001
`define ALUSEL_ADD      3'b010
`define ALUSEL_SUB      3'b110
`define ALUSEL_SLT      3'b111
`define ALUSEL_DEFAULT  3'bxxx

`define MIPSFUNC_ADD  6'b100000
`define MIPSFUNC_SUB  6'b100010
`define MIPSFUNC_AND  6'b100100
`define MIPSFUNC_OR   6'b100101
`define MIPSFUNC_SLT  6'b101010
`define MIPSFUNC_JR   6'b001000

`define NOP 32'h00000025
