/* 
 * Forwarding unit
 * (c) 2008 The University of Aizu
 */ 

module forwarding
  (
    id_source,
    id_target,
    ex_dst,
    ex_write,
    mem_dst,
    mem_write,
    mem_memread, 	 
    fwd_ex_id_A,
    fwd_mem_id_A,
    fwd_dmem_id_A,	 
    fwd_ex_id_B,
    fwd_mem_id_B,
    fwd_dmem_id_B
   );

   input [4:0] 	 id_source;
   input [4:0] 	 id_target;
   input [4:0] 	 ex_dst;
   input 	 ex_write;
   input [4:0] 	 mem_dst;
   input 	 mem_write;
   input 	 mem_memread;
   output 	 fwd_ex_id_A;
   output  	 fwd_mem_id_A;
   output  	 fwd_dmem_id_A;
   output  	 fwd_ex_id_B;
   output  	 fwd_mem_id_B;
   output  	 fwd_dmem_id_B;
   
   reg	 fwd_ex_id_A;
   reg 	 fwd_mem_id_A;
   reg 	 fwd_dmem_id_A;
   reg 	 fwd_ex_id_B;
   reg 	 fwd_mem_id_B;
   reg 	 fwd_dmem_id_B;
   
   always @(id_source or id_target or ex_dst or ex_write or mem_dst or mem_write or mem_memread) begin
      if(ex_write && (ex_dst != 5'b0) && (id_source == ex_dst)) begin
	 fwd_ex_id_A   <= 1'b1;
	 fwd_mem_id_A  <= 1'b0;
	 fwd_dmem_id_A <= 1'b0;
      end
      else if(mem_write && (mem_dst != 5'b0) &&
	      (id_source != ex_dst) && (id_source == mem_dst))
	 if(mem_memread) begin
	    fwd_ex_id_A   <= 1'b0;
	    fwd_mem_id_A  <= 1'b0;
	    fwd_dmem_id_A <= 1'b1;
	 end
	 else begin
	    fwd_ex_id_A   <= 1'b0;
	    fwd_mem_id_A  <= 1'b1;
	    fwd_dmem_id_A <= 1'b0;
	 end
      else begin
	 fwd_ex_id_A   <= 1'b0;
	 fwd_mem_id_A  <= 1'b0;
	 fwd_dmem_id_A <= 1'b0;
      end
      
      if(ex_write && (ex_dst != 5'b0) && (id_target == ex_dst)) begin
	 fwd_ex_id_B   <= 1'b1;
	 fwd_mem_id_B  <= 1'b0;
	 fwd_dmem_id_B <= 1'b0;
      end
      else if(mem_write && (mem_dst != 5'b0) &&
	      (id_target != ex_dst) && (id_target == mem_dst))
	 if(mem_memread) begin
	    fwd_ex_id_B  <= 1'b0;
	    fwd_mem_id_B <= 1'b0;
	    fwd_dmem_id_B <= 1'b1;
	 end
	 else begin
	    fwd_ex_id_B  <= 1'b0;
	    fwd_mem_id_B <= 1'b1;
	    fwd_dmem_id_B <= 1'b0;
	 end
      else begin
	 fwd_ex_id_B  <= 1'b0;
	 fwd_mem_id_B <= 1'b0;
	 fwd_dmem_id_B <= 1'b0;
      end
   end
   
endmodule

