module mipspipe_test;
   parameter addr_width  = 20;
   parameter word_length = 32;
   
   reg         clk, reset;
   wire [31:0] imem_adr, inst_data;
   wire [31:0] dmem_adr, dmem_read, dmem_write;
   wire        dmem_wen, dmem_ren;
   
   mipspipe cpu32
     (
      .clk           (clk),
      .reset         (reset),
      .dmem_read     (dmem_ren),
      .dmem_adr      (dmem_adr),
      .dmem_write    (dmem_wen),
      .dmem_data     (dmem_read),
      .dmem_data_out (dmem_write),
      .imem_adr      (imem_adr),
      .imem_data     (inst_data)
      );
   
   basic_memoryif #(addr_width,word_length) Mem
     (
      .imem_data_out (inst_data[word_length-1:0]),
      .imem_addr     (imem_adr[addr_width-1:0]),
      .dmem_data_in  (dmem_write[word_length-1:0]),
      .dmem_data_out (dmem_read[word_length-1:0]),
      .dmem_addr     (dmem_adr[addr_width-1:0]),
      .dmem_write    (dmem_wen),
      .dmem_read     (dmem_ren),
      .clk           (clk)
      );   
   
   initial
     begin
	// text segment
	Mem.imem.mem_cell['h0000] = 32'h08000400;   // j 0x1000
	
	Mem.imem.mem_cell['h1000] = 32'h00004025;   // or $8, $0, $0                   ;
	Mem.imem.mem_cell['h1004] = 32'h00004825;   // or $9, $0, $0                   ;
	Mem.imem.mem_cell['h1008] = 32'h00005025;   // or $10, $0, $0                  ;
	Mem.imem.mem_cell['h100c] = 32'h00005825;   // or $11, $0, $0                  ;
	Mem.imem.mem_cell['h1010] = 32'h8c0c5000;   // lw $12, 20480($0) [N]           ;
	Mem.imem.mem_cell['h1014] = 32'h00006825;   // or $13, $0, $0                  ;
	Mem.imem.mem_cell['h1018] = 32'h00007025;   // or $14, $0, $0                  ;
	Mem.imem.mem_cell['h101c] = 32'h00007825;   // or $15, $0, $0                  ;
	Mem.imem.mem_cell['h1020] = 32'h34105004;   // ori $16, $0, 20484 [A]          ;
	Mem.imem.mem_cell['h1024] = 32'h34115044;   // ori $17, $0, 20548 [B]          ;
	Mem.imem.mem_cell['h1028] = 32'h34125084;   // ori $18, $0, 20612 [S]          ;
	Mem.imem.mem_cell['h102c] = 32'h20130001;   // addi $19, $0, 1                 ;
	Mem.imem.mem_cell['h1030] = 32'h0000a025;   // or $20, $0, $0                  ;
	Mem.imem.mem_cell['h1034] = 32'h0000a825;   // or $21, $0, $0                  ;
	Mem.imem.mem_cell['h1038] = 32'h08000420;   // j 0x00001080 [loopk]            ;
	Mem.imem.mem_cell['h103c] = 32'h21080001;   // addi $8, $8, 1                  ;
	Mem.imem.mem_cell['h1040] = 32'hae4f0000;   // sw $15, 0($18)                  ;
	Mem.imem.mem_cell['h1044] = 32'h110c0024;   // beq $8, $12, 144 [exit-0x00001044];
	Mem.imem.mem_cell['h1048] = 32'h22520004;   // addi $18, $18, 4                ;
	Mem.imem.mem_cell['h104c] = 32'h00007825;   // or $15, $0, $0                  ;
	Mem.imem.mem_cell['h1050] = 32'h2231ffb4;   // addi $17, $17, -76              ;
	Mem.imem.mem_cell['h1054] = 32'h00004825;   // or $9, $0, $0                   ;
	Mem.imem.mem_cell['h1058] = 32'h00005025;   // or $10, $0, $0                  ;
	Mem.imem.mem_cell['h105c] = 32'h08000420;   // j 0x00001080 [loopk]            ;
	Mem.imem.mem_cell['h1060] = 32'h21290001;   // addi $9, $9, 1                  ;
	Mem.imem.mem_cell['h1064] = 32'h112cfff5;   // beq $9, $12, -44 [loopi-0x00001064];
	Mem.imem.mem_cell['h1068] = 32'hae4f0000;   // sw $15, 0($18)                  ;
	Mem.imem.mem_cell['h106c] = 32'h22520004;   // addi $18, $18, 4                ;
	Mem.imem.mem_cell['h1070] = 32'h00007825;   // or $15, $0, $0                  ;
	Mem.imem.mem_cell['h1074] = 32'h2210fff0;   // addi $16, $16, -16              ;
	Mem.imem.mem_cell['h1078] = 32'h2231ffc4;   // addi $17, $17, -60              ;
	Mem.imem.mem_cell['h107c] = 32'h00005025;   // or $10, $0, $0                  ;
	Mem.imem.mem_cell['h1080] = 32'h114cfff7;   // beq $10, $12, -36 [loopj-0x00001080];
	Mem.imem.mem_cell['h1084] = 32'h8e0d0000;   // lw $13, 0($16)                  ;
	Mem.imem.mem_cell['h1088] = 32'h8e2e0000;   // lw $14, 0($17)                  ;
	Mem.imem.mem_cell['h108c] = 32'h00005825;   // or $11, $0, $0                  ;
	Mem.imem.mem_cell['h1090] = 32'h20130001;   // addi $19, $0, 1                 ;
	Mem.imem.mem_cell['h1094] = 32'h0000a025;   // or $20, $0, $0                  ;
	Mem.imem.mem_cell['h1098] = 32'h0000a825;   // or $21, $0, $0                  ;
	Mem.imem.mem_cell['h109c] = 32'h116c0009;   // beq $11, $12, 36 [loopk2-0x0000109c];
	Mem.imem.mem_cell['h10a0] = 32'h216b0001;   // addi $11, $11, 1                ;
	Mem.imem.mem_cell['h10a4] = 32'h01d3a024;   // and $20, $14, $19               ;
	Mem.imem.mem_cell['h10a8] = 32'h02739820;   // add $19, $19, $19               ;
	Mem.imem.mem_cell['h10ac] = 32'h12800003;   // beq $20, $0, 12 [notone-0x000010ac];
	Mem.imem.mem_cell['h10b0] = 32'h01b5a820;   // add $21, $13, $21               ;
	Mem.imem.mem_cell['h10b4] = 32'h01ad6820;   // add $13, $13, $13               ;
	Mem.imem.mem_cell['h10b8] = 32'h08000427;   // j 0x0000109c [multi]            ;
	Mem.imem.mem_cell['h10bc] = 32'h01ad6820;   // add $13, $13, $13               ;
	Mem.imem.mem_cell['h10c0] = 32'h08000427;   // j 0x0000109c [multi]            ;
	Mem.imem.mem_cell['h10c4] = 32'h01f57820;   // add $15, $15, $21               ;
	Mem.imem.mem_cell['h10c8] = 32'h22100004;   // addi $16, $16, 4                ;
	Mem.imem.mem_cell['h10cc] = 32'h22310010;   // addi $17, $17, 16               ;
	Mem.imem.mem_cell['h10d0] = 32'h214a0001;   // addi $10, $10, 1                ;
	Mem.imem.mem_cell['h10d4] = 32'h08000420;   // j 0x00001080 [loopk]            ;
	Mem.imem.mem_cell['h10d8] = 32'h08000436;   // j 0x000010d8 [exit]             ;
	
	// data segment
	Mem.dmem.mem_cell['h5000] = 32'h00000004;	// # νġĹ
	Mem.dmem.mem_cell['h5004] = 32'h00000000;	// # 1ܤιA
	Mem.dmem.mem_cell['h5008] = 32'h00000000;
	Mem.dmem.mem_cell['h500c] = 32'h00000000;
	Mem.dmem.mem_cell['h5010] = 32'h00000001;
	Mem.dmem.mem_cell['h5014] = 32'h00000000;
	Mem.dmem.mem_cell['h5018] = 32'h00000002;
	Mem.dmem.mem_cell['h501c] = 32'h00000000;
	Mem.dmem.mem_cell['h5020] = 32'h00000000;
	Mem.dmem.mem_cell['h5024] = 32'h00000000;
	Mem.dmem.mem_cell['h5028] = 32'h00000000;
	Mem.dmem.mem_cell['h502c] = 32'h00000003;
	Mem.dmem.mem_cell['h5030] = 32'h00000000;
	Mem.dmem.mem_cell['h5034] = 32'h00000004;
	Mem.dmem.mem_cell['h5038] = 32'h00000000;
	Mem.dmem.mem_cell['h503c] = 32'h00000000;
	Mem.dmem.mem_cell['h5040] = 32'h00000000;
	
	Mem.dmem.mem_cell['h5044] = 32'h00000000;	// # 2ܤιB
	Mem.dmem.mem_cell['h5048] = 32'h00000001;
	Mem.dmem.mem_cell['h504c] = 32'h00000002;
	Mem.dmem.mem_cell['h5050] = 32'h00000003;
	Mem.dmem.mem_cell['h5054] = 32'h00000004;
	Mem.dmem.mem_cell['h5058] = 32'h00000005;
	Mem.dmem.mem_cell['h505c] = 32'h00000006;
	Mem.dmem.mem_cell['h5060] = 32'h00000007;
	Mem.dmem.mem_cell['h5064] = 32'h00000008;
	Mem.dmem.mem_cell['h5068] = 32'h00000009;
	Mem.dmem.mem_cell['h506c] = 32'h0000000a;
	Mem.dmem.mem_cell['h5070] = 32'h0000000b;
	Mem.dmem.mem_cell['h5074] = 32'h0000000c;
	Mem.dmem.mem_cell['h5078] = 32'h0000000d;
	Mem.dmem.mem_cell['h507c] = 32'h0000000e;
	Mem.dmem.mem_cell['h5080] = 32'h0000000f;
	// # ̤ǼS
	Mem.dmem.mem_cell['h5084] = 32'h00000000;	// # :12(0xc)
	Mem.dmem.mem_cell['h5088] = 32'h00000000;	// # :13(0xd)
	Mem.dmem.mem_cell['h508c] = 32'h00000000;	// # :14(0xe)
	Mem.dmem.mem_cell['h5090] = 32'h00000000;	// # :15(0xf)
	Mem.dmem.mem_cell['h5094] = 32'h00000000;	// # :8
	Mem.dmem.mem_cell['h5098] = 32'h00000000;	// # :10(0xa)
	Mem.dmem.mem_cell['h509c] = 32'h00000000;	// # :12(0xc)
	Mem.dmem.mem_cell['h50a0] = 32'h00000000;	// # :14(0xe)
	Mem.dmem.mem_cell['h50a4] = 32'h00000000;	// # :24(0x18)
	Mem.dmem.mem_cell['h50a8] = 32'h00000000;	// # :27(0x1b)
	Mem.dmem.mem_cell['h50ac] = 32'h00000000;	// # :30(0x1e)
	Mem.dmem.mem_cell['h50b0] = 32'h00000000;	// # :33(0x21)
	Mem.dmem.mem_cell['h50b4] = 32'h00000000;	// # :0
	Mem.dmem.mem_cell['h50b8] = 32'h00000000;	// # :4
	Mem.dmem.mem_cell['h50bc] = 32'h00000000;	// # :8
	Mem.dmem.mem_cell['h50c0] = 32'h00000000;	// # :12(0xc)
	
	clk = 1'b1;
	reset = 1'b1;
	#110
	reset = 1'b0;
	#400000
	$display("RESULT:");
	$display("[12 13 14 15] %d%d%d%d", Mem.dmem.mem_cell['h5084], Mem.dmem.mem_cell['h5088], Mem.dmem.mem_cell['h508c], Mem.dmem.mem_cell['h5090]);
	$display("[ 8 10 12 14] %d%d%d%d", Mem.dmem.mem_cell['h5094], Mem.dmem.mem_cell['h5098], Mem.dmem.mem_cell['h509c], Mem.dmem.mem_cell['h50a0]);
	$display("[24 27 30 33] %d%d%d%d", Mem.dmem.mem_cell['h50a4], Mem.dmem.mem_cell['h50a8], Mem.dmem.mem_cell['h50ac], Mem.dmem.mem_cell['h50b0]);
	$display("[ 0  4  8 12] %d%d%d%d", Mem.dmem.mem_cell['h50b4], Mem.dmem.mem_cell['h50b8], Mem.dmem.mem_cell['h50bc], Mem.dmem.mem_cell['h50c0]);
        $finish;
     end
   
   always #50 clk = ~clk;

endmodule
