# SimVision Command Script (Tue Jul 15 00:47:14 JST 2008)
#
# Version 05.60.p001
#
# You can restore this configuration with:
#
# simvision -input simvision.sv
#

#
# preferences
#
preferences set toolbar-Windows-WaveWindow {
  usual
  hide icheck
  position -pos 3
}
preferences set toolbar-Windows-WatchList {
  usual
  hide icheck
}

#
# databases
#
database require mipspipe_sample -search {
	./mipspipe_sample/mipspipe_sample.trn
}

#
# mmaps
#
mmap new -reuse -name {Boolean as Logic} -contents {
{%c=FALSE -edgepriority 1 -shape low}
{%c=TRUE -edgepriority 1 -shape high}
}
mmap new -reuse -name {Example Map} -contents {
{%b=11???? -bgcolor orange -label REG:%x -linecolor yellow -shape bus}
{%x=1F -bgcolor red -label ERROR -linecolor white -shape EVENT}
{%x=2C -bgcolor red -label ERROR -linecolor white -shape EVENT}
{%x=* -label %x -linecolor gray -shape bus}
}

#
# Design Browser windows
#
if {[catch {window new WatchList -name "Design Browser 1" -geometry 700x500+945+55}] != ""} {
 window geometry "Design Browser 1" 700x500+945+55 
}
window target "Design Browser 1" on
browser using {Design Browser 1}
browser set \
    -scope mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit
browser yview see mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit
browser timecontrol set -lock 0

#
# Waveform windows
#
if {[catch {window new WaveWindow -name "Waveform 1" -geometry 1010x600+110+218}] != ""} {
    window geometry "Waveform 1" 1010x600+110+218
}
window target "Waveform 1" on
waveform using {Waveform 1}
waveform sidebar visibility partial
waveform set \
    -primarycursor TimeA \
    -signalnames name \
    -signalwidth 138 \
    -units ns \
    -valuewidth 76
cursor set -using TimeA -time 0

set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.clk ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.reset ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.if_curpc[31:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.id_pcadr[31:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.ex_pcadr[31:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.mem_pcadr[31:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.wb_pcadr[31:0]} ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_stall ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_ex_id_A ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_ex_id_B ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_mem_id_A ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_mem_id_B ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_dmem_id_A ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.fwd_dmem_id_B ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.id_source[4:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.id_target[4:0]} ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.ex_dst[4:0]} ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.ex_write ]]
set id [waveform add -signals [list {mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.mem_dst[4:0]} ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.mem_write ]]
set id [waveform add -signals [list mipspipe_sample::mipspipe_sample.cpu32.id_fwd_unit.mem_memread ]]

waveform xview limits 0 1000ns
