/* 
 * Instruction decoder
 * (c) 2008 The University of Aizu
 */ 

module instdec_pipe
(
 Op,

 Branch,
 Jump,
 RegDst,
 ALUOp,
 ALUSrc,
 MemRead,
 MemWrite,
 RegWrite,
 MemtoReg,
 RAWrite,
 ExtType
 );
   
   input  [5:0] Op;
   
   output     Branch;
   output     Jump;
   output     RegDst;
   output [1:0] ALUOp;
   output     ALUSrc;
   output     MemRead;
   output     MemWrite;
   output     RegWrite;
   output     MemtoReg;
   output     RAWrite;
   output     ExtType;

   reg 	    Branch;
   reg 	    Jump;
   reg 	    RegDst;
   reg [1:0] ALUOp;
   reg 	    ALUSrc;
   reg 	    MemRead;
   reg 	    MemWrite;
   reg 	    RegWrite;
   reg 	    MemtoReg;
   reg      RAWrite;
      
   always @(Op) begin
      casex(Op) 
	`MIPSINST_R_TYPE : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b00_1_10_0_0_0_1_0_0;
	`MIPSINST_LW     : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b00_0_00_1_1_0_1_1_0;
	`MIPSINST_SW     : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b00_0_00_1_0_1_0_0_0;
	`MIPSINST_BEQ    : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b10_0_01_0_0_0_0_0_0;
	`MIPSINST_J      : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b01_0_00_0_0_0_0_0_0;
	`MIPSINST_JAL    : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b01_0_00_0_0_0_1_0_1;
	`MIPSINST_I_TYPE : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 11'b00_0_11_1_0_0_1_0_0;
	default          : {Branch, Jump, RegDst, ALUOp, ALUSrc, MemRead, MemWrite, RegWrite, MemtoReg, RAWrite} <= 'bx;
      endcase // casex(Op)
   end // always @ (Op)

   assign ExtType = (Op == `MIPSINST_ANDI) | (Op == `MIPSINST_ORI);

endmodule
