/*
 * Datapath modules for MIPS CPU
 * (c) 2008 The University of Aizu
 */

module register
  //#(parameter width = 32)
    (
    clock,
    in,
    out
     );
   parameter width = 32;
   
   input 	     clock;
   input [width-1:0] in;
   output[width-1:0] out;
   
   reg [width-1:0]   out;
   
   always @(posedge clock)
     out <= in;
   
endmodule

module register_r
  //#(parameter  width=32)
    (
    clock,
    reset,
    in,
    out
     );

   parameter width = 32;
   
   input 	     clock;
   input 	     reset;
   input [width-1:0] in;
   output[width-1:0] out;
   
   reg [width-1:0]   out;

   always @(posedge clock)
     out <= (reset) ? 'b0 : in;
   
endmodule

module register_e
  //#(parameter width = 32)
    (
    clock,
    en,
    in,
    out
     );
    
   parameter width = 32;
   
   input 	     clock;
   input 	     en;
   input [width-1:0] in;
   output[width-1:0] out;
   
   reg [width-1:0]   out;
   
   always @(posedge clock)
     out <= (en) ? out : in;
   
endmodule

module register_re
  //#(parameter width = 32)
    (
    clock,
    reset,
    en,
    in,
    out
     );
   
   parameter width = 32;
   
   input 	     clock;
   input 	     reset;
   input 	     en;
   input [width-1:0] in;
   output[width-1:0] out;
   
   reg [width-1:0]   out;
   always @(posedge clock)
     out <= (reset) ? 'b0 : (en) ? out : in;
   
endmodule

module mux2
  //#(parameter width = 32)
    (
     sel,
     in0,
     in1,
     out
     );
    
   parameter width = 32;
   
   input 	     sel;
   input [width-1:0] in0;
   input [width-1:0] in1;
   output[width-1:0] out;

   reg[width-1:0] out;
      
   always @(sel or in0 or in1) begin
      case (sel)
	1'b0    : out = in0;
	1'b1    : out = in1;
	default : out = 'bx;
      endcase // case(sel)
   end
   
endmodule

module mux4
  //#(parameter width = 32)
    (
     sel,
     in0,
     in1,
     in2,
     in3,
     out
     );
   parameter width = 32;

   input      [1:0]       sel;
   input [width-1:0] 	  in0;
   input [width-1:0] 	  in1;
   input [width-1:0] 	  in2;
   input [width-1:0] 	  in3;
   output[width-1:0] out;
      
   reg [width-1:0]   out;
      
   always @(sel or in0 or in1 or in2 or in3) begin
      case (sel)
	2'b00   : out = in0;
	2'b01   : out = in1;
	2'b10   : out = in2;
	2'b11   : out = in3;
	default : out = 'bx;
      endcase // case(sel)
   end
   
endmodule

module mux8
  //#(parameter width = 32)
    (
     sel,
     in0,
     in1,
     in2,
     in3,
     in4,
     in5,
     in6,
     in7,
     out
     );
   parameter width = 32;

   input      [2:0]       sel;
   input [width-1:0] 	  in0;
   input [width-1:0] 	  in1;
   input [width-1:0] 	  in2;
   input [width-1:0] 	  in3;
   input [width-1:0] 	  in4;
   input [width-1:0] 	  in5;
   input [width-1:0] 	  in6;
   input [width-1:0] 	  in7;
   output [width-1:0] out;
   
   reg [width-1:0]    out;
   
   always @(sel or in0 or in1 or in2 or 
	    in3 or in4 or in5 or in6 or in7) begin
      case (sel)
	3'b000  : out = in0;
	3'b001  : out = in1;
	3'b010  : out = in2;
	3'b011  : out = in3;
	3'b100  : out = in4;
	3'b101  : out = in5;
	3'b110  : out = in6;
	3'b111  : out = in7;
	default : out = 'bx;
      endcase // case(sel)
   end
   
endmodule


module adder
  //#(parameter width = 32)
    (
     inA,
     inB,
     out
     );
   parameter width = 32;
   
   input  [width-1:0] inA;
   input [width-1:0]  inB;
   output [width-1:0] out;
   
   assign out = inA + inB;

endmodule
