// constant definition for opcode
`define RTYPE 0
`define LW 35
`define SW 43
`define BEQ 4
`define JMP 2
`define ADDI 8
`define SLTI 10
`define ANDI 12
`define ORI 13

module ControlUnit(PCWriteCond, PCWrite, IorD, MemRead, MemWrite, MemtoReg, 
                   IRWrite, PCSource, ALUOp, ALUSrcB, ALUSrcA, 
                   RegWrite, RegDST, Op, CK, CLR);

   // clock 
   input CK;
   input CLR;

   // opcode (6 bit)
   input [5:0] Op;
   
   // 1 bit control signal
   output      PCWriteCond;
   output      PCWrite;
   output      IorD;
   output      MemRead;
   output      MemWrite;
   output      MemtoReg;
   output      IRWrite;
   output      RegWrite;
   output      RegDST;
   output      ALUSrcA;
   
   // 2 bit control signal
   output [1:0] PCSource;
   output [1:0] ALUOp;
   output [2:0] ALUSrcB;

   // register declaration
   reg 		PCWriteCond;
   reg 		PCWrite;
   reg 		IorD;
   reg 		MemRead;
   reg 		MemWrite;
   reg 		MemtoReg;
   reg 		IRWrite;
   reg [1:0] 	PCSource;
   reg [1:0] 	ALUOp;
   reg [2:0] 	ALUSrcB;
   reg 		ALUSrcA;
   reg 		RegWrite;
   reg 		RegDST;

   // state register
   reg [3:0] 	state;

   always @(posedge CK or posedge CLR)
     begin
	if(CLR==1) state <= 0;
	else
          case(state)
	    0: state <= 1;
	    1:
	      begin
		 if(Op == `LW || Op == `SW)
		   state <= 2;
		 else if(Op == `RTYPE)
		   state <= 6;
		 else if(Op == `BEQ)
		   state <= 8;
		 else if(Op == `JMP)
		   state <= 9;
		 else if(Op == `ADDI || Op == `SLTI)
		   state <= 10;
		 else if(Op == `ANDI || Op == `ORI)
		   state <= 12;
	      end // case: 1
	    
	    2:
	      begin
		 if(Op == `LW)
		   state <= 3;
		 else if(Op == `SW)
		   state <= 5;
	      end

	    3: state <= 4;
	    4: state <= 0;
	    5: state <= 0;
	    6: state <= 7;
	    7: state <= 0;
	    8: state <= 0;
	    9: state <= 0;
	    10: state <= 11;
	    11: state <= 0;
	    12: state <= 11;

	    default: ;

	  endcase // case (state)
     end // always @ (posedge CK or posedge CLR)
endmodule // ControlUnit
