`timescale 1ns/1ps
`include "ControlUnit_1.v"

module CUbench;

   reg ck;
   reg clr;
   reg [5:0] op;
   wire      pcwritecond;
   wire      pcwrite;
   wire      iord;
   wire      memread;
   wire      memwrite;
   wire      memtoreg;
   wire      irwrite;
   wire [1:0] pcsource;
   wire [1:0] aluop;
   wire [2:0] alusrcb;
   wire       alusrca;
   wire       regwrite;
   wire       regdst;

   ControlUnit cu(.PCWriteCond(pcwritecond), .PCWrite(pcwrite), .IorD(iord), .MemRead(memread), .MemWrite(memwrite), .MemtoReg(memtoreg), .IRWrite(irwrite), .PCSource(pcsource), .ALUOp(aluop), .ALUSrcB(alusrcb), .ALUSrcA(alusrca), .RegWrite(regwrite), .RegDST(regdst), .Op(op), .CK(ck), .CLR(clr));

   initial
     begin
	$dumpfile("CUbench_1.vcd");
	$dumpvars(0, cu);

	// initialize
	ck = 1'b0;
	clr = 1'b1;

	#60
	
	// operation = RTYPE(register type)
	op = 0;
	clr = 1'b0;

	$display("\noperation = RTYPE");

	// 4 cycles 
	#100
	#100
	#100
	#100
	  
	  clr = 1'b1;
	#160
	  
	  $finish;
     end // initial begin
   
   always #50 ck = ~ck;
endmodule // CUbench
