`timescale 1ns/1ps
`include "ControlUnit.v"


module CUbench;

   reg ck;
   reg clr;
   reg [5:0] op;

   wire      pcwritecond;
   wire      pcwrite;
   wire      iord;
   wire      memread;
   wire      memwrite;
   wire      memtoreg;
   wire      irwrite;
   wire [1:0] pcsource;
   wire [1:0] aluop;
   wire [2:0] alusrcb;
   wire       alusrca;
   wire       regwrite;
   wire       regdst;

   ControlUnit cu(.PCWriteCond(pcwritecond), .PCWrite(pcwrite), .IorD(iord), .MemRead(memread), .MemWrite(memwrite), .MemtoReg(memtoreg), .IRWrite(irwrite), .PCSource(pcsource), .ALUOp(aluop), .ALUSrcB(alusrcb), .ALUSrcA(alusrca), .RegWrite(regwrite), .RegDST(regdst), .Op(op), .CK(ck), .CLR(clr));


   initial
     begin

	$dumpfile("CUbench.vcd");
	$dumpvars(0, cu);

	// initialize
	#0
	ck = 1'b1;
        clr = 1'b1;
        op = 0;
 
	#125
	clr = 1'b0;

	// operation = LW
        op = 35; 
	#75
	$display("\noperation = LW");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: MemRead=%b,IorD=%b",cu.state,cu.MemRead,cu.IorD);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);

	// reset  
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

	// operation = SW
        op = 43;
	#75
	$display("\noperation = SW");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: MemWrite=%b,IorD=%b\n",cu.state,cu.MemWrite,cu.IorD);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

	// operation = RTYPE(register type)
        op = 0; 
	#75
	$display("\noperation = RTYPE");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

	// operation = BEQ
	op = 4; 
	#75
	$display("\noperation = BEQ");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b,PCWriteCond=%b,PCSource=%b\n",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp,cu.PCWriteCond,cu.PCSource);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

        // operation = JMP
	op = 2; 
	#75
	$display("\noperation = JMP");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: PCWrite=%b,PCSource=%b\n",cu.state,cu.PCWrite,cu.PCSource);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

	// operation = ADDI
	op = 8; 
	#75
	$display("\noperation = ADDI");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;

	// operation = SLTI
	op = 10; 
	#75
	$display("\noperation = SLTI");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);

	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;


	// operation = ANDI
        op = 12; 
	#75
	$display("\noperation = ANDI");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);


	// reset  
	clr = 1'b0;
	#75
        clr = 1'b1;
        #50
	clr = 1'b0;


	// operation = ORI
        op = 13; 
	#75
	$display("\noperation = ORI");
	$display("state=%d: MemRead=%b,ALUSrcA=%b,IorD=%b,IRWrite=%b,ALUSrcB=%b,ALUOp=%b,PCWrite=%b,PCSource=%b",cu.state,cu.MemRead,cu.ALUSrcA,cu.IorD,cu.IRWrite,cu.ALUSrcB,cu.ALUOp,cu.PCWrite,cu.PCSource);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: ALUSrcA=%b,ALUSrcB=%b,ALUOp=%b",cu.state,cu.ALUSrcA,cu.ALUSrcB,cu.ALUOp);
	#100
	  $display("state=%d: RegDst=%b,RegWrite=%b,MemtoReg=%b\n",cu.state,cu.RegDST,cu.RegWrite,cu.MemtoReg);

	#200

        $finish;
     end

   always #50 ck = ~ck;

endmodule
