module mipspipe_sample;
   parameter addr_width  = 20;
   parameter word_length = 32;
   
   reg         clk, reset;
   wire [31:0] imem_adr, inst_data;
   wire [31:0] dmem_adr, dmem_read, dmem_write;
   wire        dmem_wen, dmem_ren;
   
   mipspipe cpu32
     (
      .clk           (clk),
      .reset         (reset),
      .dmem_read     (dmem_ren),
      .dmem_adr      (dmem_adr),
      .dmem_write    (dmem_wen),
      .dmem_data     (dmem_read),
      .dmem_data_out (dmem_write),
      .imem_adr      (imem_adr),
      .imem_data     (inst_data)
      );
   
   basic_memoryif #(addr_width,word_length) Mem
     (
      .imem_data_out (inst_data[word_length-1:0]),
      .imem_addr     (imem_adr[addr_width-1:0]),
      .dmem_data_in  (dmem_write[word_length-1:0]),
      .dmem_data_out (dmem_read[word_length-1:0]),
      .dmem_addr     (dmem_adr[addr_width-1:0]),
      .dmem_write    (dmem_wen),
      .dmem_read     (dmem_ren),
      .clk           (clk)
      );   
   
   initial
     begin
        $shm_open("./mipspipe_sample");
        $shm_probe(mipspipe_sample, "AS");

	// text segment
	Mem.imem.mem_cell['h00000000] = 32'h08000400;   // j 0x1000
	
	Mem.imem.mem_cell['h00001000] = 32'h00004025;   // or $8, $0, $0         ; 9: or   $8, $0, $0
	Mem.imem.mem_cell['h00001004] = 32'h34095000;   // ori $9, $0, 20480 [A] ; 10: la   $9, A
	Mem.imem.mem_cell['h00001008] = 32'h8d2a0000;   // lw $10, 0($9)         ; 12: lw   $10, 0($9)
	Mem.imem.mem_cell['h0000100c] = 32'h010a4020;   // add $8, $8, $10       ; 13: add  $8, $8, $10
	Mem.imem.mem_cell['h00001010] = 32'h8d2a0004;   // lw $10, 4($9)         ; 15: lw   $10, 4($9)
	Mem.imem.mem_cell['h00001014] = 32'h010a4020;   // add $8, $8, $10       ; 16: add  $8, $8, $10
	Mem.imem.mem_cell['h00001018] = 32'h8d2a0008;   // lw $10, 8($9)         ; 18: lw   $10, 8($9)
	Mem.imem.mem_cell['h0000101c] = 32'h010a4020;   // add $8, $8, $10       ; 19: add  $8, $8, $10
	Mem.imem.mem_cell['h00001020] = 32'h8d2a000c;   // lw $10, 12($9)        ; 21: lw   $10, 12($9)
	Mem.imem.mem_cell['h00001024] = 32'h010a4020;   // add $8, $8, $10       ; 22: add  $8, $8, $10
	Mem.imem.mem_cell['h00001028] = 32'hac085010;   // sw $8, 20496($0) [S]  ; 24: sw   $8, S
	Mem.imem.mem_cell['h0000102c] = 32'h0800040b;   // j 0x0000102c [exit]   ; 25: j exit

	// data segment
	Mem.dmem.mem_cell['h00005000] = 32'h00000013;
	Mem.dmem.mem_cell['h00005004] = 32'h0000004b;
	Mem.dmem.mem_cell['h00005008] = 32'h0000000a;
	Mem.dmem.mem_cell['h0000500c] = 32'h0000000f;
	Mem.dmem.mem_cell['h00005010] = 32'h00000000;
	
	clk = 1'b1;
	reset = 1'b1;
	#110
	reset = 1'b0;
	#3000
        $display("RESULT:");
	$display("%x", Mem.dmem.mem_cell['h5010]);
        $finish;
     end
   
   always #50 clk = ~clk;

endmodule
