/*
 * Memory modulesr
 * (c) 2008 The University of Aizu
 */ 

module simple_sram
  //#(parameter addr_width  = 16,
  //  parameter word_length = 32)
    (
     clk,
     write, read,
     addr,
     data_in,
     data_out
     );
   parameter addr_width  = 16;
   parameter word_length = 32;

   input                    clk;
   input                    write, read;
   input [addr_width-1:0]   addr;
   input [word_length-1:0]  data_in;
   output [word_length-1:0] data_out;
     
   reg [word_length-1:0] mem_cell[0:(1<<addr_width)-1];
   
   assign data_out = (write) ? data_in : (read) ? mem_cell[addr] : 'hz;
   
   always @(posedge clk)
     if(write)
       mem_cell[addr] <= data_in;
   
endmodule

module basic_memoryif
  //#(parameter addr_width  = 16,
  //  parameter word_length = 32)
    (
     clk,
   
     imem_data_out,
     imem_addr,
   
     dmem_data_in,
     dmem_data_out,
     dmem_addr,
     dmem_write,
     dmem_read
   ); 
   parameter addr_width  = 16;
   parameter word_length = 32;
   
   input         clk;
   
   output [word_length-1:0] imem_data_out;
   input [addr_width-1:0]   imem_addr;
   
   input [word_length-1:0]  dmem_data_in;
   output [word_length-1:0] dmem_data_out;
   input [addr_width-1:0]   dmem_addr;
   input 		    dmem_write;
   input 		    dmem_read;
   
   simple_sram  #(addr_width,word_length)
     imem (
	   .clk(clk),
	   .data_in('hz),
	   .data_out(imem_data_out),
	   .addr(imem_addr[addr_width-1:0]),
	   .write(1'b0),
	   .read(1'b1)
	   );
   
   simple_sram  #(addr_width,word_length)
     dmem(
	  .clk(clk),
	  .data_in(dmem_data_in),
	  .data_out(dmem_data_out),
	  .addr(dmem_addr[addr_width-1:0]),
	  .write(dmem_write),
	  .read(dmem_read)
	  );
   
endmodule // basic_memoryif


