/* 
 * Hazard detection unit
 * (c) 2008 The University of Aizu
 */ 

module hazard
  (
    id_source,
    id_target,
    ex_mem_read,
    ex_dst,
    mem_mem_read,
    mem_dst,
    id_inst_jr,
    mem_rawrite, 	
    stall
   );
   input [4:0] 	id_source;
   input [4:0] 	id_target;
   input 	ex_mem_read;
   input [4:0] 	ex_dst;
   input 	mem_mem_read;
   input [4:0] 	mem_dst;
   input 	id_inst_jr;
   input 	mem_rawrite;
   output 	stall;
   
   assign stall = (ex_mem_read & ((id_source == ex_dst) | (id_target == ex_dst))) |
		  (id_inst_jr & mem_rawrite);

endmodule
